
format PE64 GUI 5.0
entry start

include 'win64a.inc'

SEC_IMAGE	= 1000000h
KEY_WOW64_32KEY = 200h

section '.code' code readable executable

  start:
	sub	rsp,8*(4+1)
	xor	ecx,ecx
	call	[GetModuleHandle]
	and	qword [rsp+8*(4+0)],0
	lea	r9,[DialogProc]
	xor	r8,r8
	lea	edx,[r8+IDD_MAIN]
	xchg	rax,rcx
	call	[DialogBoxParam]
	xor	ecx,ecx
	call	[ExitProcess]

  install_dir:
	sub	rsp,8*(4+5)
	lea	rax,[rsp+8*(4+2)]
	mov	[rsp+8*(4+0)],rax
	mov	r9d,KEY_QUERY_VALUE+KEY_WOW64_32KEY
	xor	r8,r8
	lea	rdx,[_key]
	mov	ecx,HKEY_LOCAL_MACHINE
	call	[RegOpenKeyEx]
	test	eax,eax
	jnz	.fin
	mov	dword [rsp+8*(4+3)],MAX_PATH
	lea	rax,[rsp+8*(4+3)]
	mov	[rsp+8*(4+1)],rax
	lea	rax,[path]
	mov	[rsp+8*(4+0)],rax
	xor	r9,r9
	xor	r8,r8
	lea	rdx,[_value]
	mov	rcx,[rsp+8*(4+2)]
	call	[RegQueryValueEx]
	mov	[rsp+8*(4+0)],eax
	mov	ecx,[rsp+8*(4+2)]
	call	[RegCloseKey]
	mov	eax,[rsp+8*(4+0)]
    .fin:
	add	rsp,8*(4+5)
	retn

  ptrn_check:
	push	r12 r13 r14
	sub	rsp,8*(4+4)
	xor	r9,r9
	mov	[rsp+8*(4+3)],r9
	mov	dword [rsp+8*(4+1)],FILE_ATTRIBUTE_NORMAL
	lea	edx,[r9+OPEN_EXISTING]
	mov	[rsp+8*(4+0)],edx
	xor	r8,r8
	mov	edx,GENERIC_READ
	lea	rcx,[path]
	call	[CreateFile]
	test	rax,rax
	js	.err
	mov	r12,rax
	xor	r9,r9
	mov	[rsp+8*(4+3)],r9
	mov	[rsp+8*(4+1)],r9
	mov	[rsp+8*(4+0)],r9
	xor	edx,edx
	lea	r8,[rdx+PAGE_READONLY]
	xchg	rax,rcx
	call	[CreateFileMapping]
	test	rax,rax
	je	.close1
	mov	r13,rax
	xor	r9,r9
	mov	[rsp+8*(4+0)],r9
	xor	r8,r8
	lea	edx,[r8+FILE_MAP_READ]
	xchg	rax,rcx
	call	[MapViewOfFile]
	test	rax,rax
	je	.close2
	mov	r14,rax
	cmp	word [rax],IMAGE_DOS_SIGNATURE
	jnz	.close3
	mov	ecx,[rax+IMAGE_DOS_HEADER.e_lfanew]
	add	rax,rcx
	cmp	dword [rax],IMAGE_NT_SIGNATURE
	jnz	.close3
	mov	r8d,[rax+IMAGE_NT_HEADERS.OptionalHeader.BaseOfCode]
	movzx	ecx,[rax+IMAGE_NT_HEADERS.FileHeader.NumberOfSections]
	mov	r9w,[rax+IMAGE_NT_HEADERS.FileHeader.SizeOfOptionalHeader]
	lea	rax,[rax+IMAGE_NT_HEADERS.OptionalHeader+r9]
    .sections:
	mov	r10d,[rax+IMAGE_SECTION_HEADER.VirtualAddress]
	add	r10d,[rax+IMAGE_SECTION_HEADER.Misc.VirtualSize]
	cmp	r10,r8
	ja	.found
	add	rax,sizeof.IMAGE_SECTION_HEADER
	loop	.sections
	jmp	.close3
    .found:
	mov	byte [rsp+8*(4+3)],1
	mov	dword [rsp+8*(4+0)],_size
	lea	r9,[_mask]
	lea	r8,[_ptrn]
	mov	edx,[rax+IMAGE_SECTION_HEADER.SizeOfRawData]
	mov	ecx,[rax+IMAGE_SECTION_HEADER.PointerToRawData]
	add	rcx,r14
	call	FindPattern
	test	rax,rax
	je	.close3
	xor	edx,edx
	cmp	byte [rax-_size_of_patch],original_first_byte
	sete	dl
	sub	rax,r14
	mov	[rsp+8*(4+2)],edx
	mov	[rsp+8*(4+3)],eax
    .close3:
	mov	rcx,r14
	call	[UnmapViewOfFile]
    .close2:
	mov	rcx,r13
	call	[CloseHandle]
    .close1:
	mov	rcx,r12
	call	[CloseHandle]
	mov	eax,[rsp+8*(4+3)]
	mov	edx,[rsp+8*(4+2)]
	jmp	.fin
    .err:
	xor	eax,eax
    .fin:
	add	rsp,8*(4+4)
	pop	r14 r13 r12
	retn

  patch:
	push	rsi rdi r12 r13 r14
a	=	5
b	=	4
d	=	4
e	=	(a+b+d+1) and 1
f	=	a+b+d
	sub	rsp,8*(b+d+e)
	mov	[rsp+8*(f+1)],rcx
	mov	[rsp+8*(f+2)],rdx
	mov	[rsp+8*(f+3)],r8
	xor	r9,r9
	mov	[rsp+8*(4+3)],r9
	mov	dword [rsp+8*(4+1)],FILE_ATTRIBUTE_NORMAL
	mov	dword [rsp+8*(4+0)],OPEN_EXISTING
	xor	r8,r8
	mov	edx,GENERIC_READ+GENERIC_WRITE
	lea	rcx,[path]
	call	[CreateFile]
	test	rax,rax
	js	.err
	mov	r12,rax
	xor	r9,r9
	mov	[rsp+8*(4+3)],r9
	mov	[rsp+8*(4+1)],r9
	mov	[rsp+8*(4+0)],r9
	xor	edx,edx
	lea	r8,[rdx+PAGE_READWRITE]
	xchg	rax,rcx
	call	[CreateFileMapping]
	test	rax,rax
	je	.close1
	mov	r13,rax
	xor	r9,r9
	mov	[rsp+8*(4+0)],r9
	xor	r8,r8
	lea	edx,[r8+FILE_MAP_WRITE]
	xchg	rax,rcx
	call	[MapViewOfFile]
	test	rax,rax
	je	.close2
	mov	r14,rax
	add	rax,[rsp+8*(f+1)]
	mov	rdi,rax
	mov	rsi,[rsp+8*(f+2)]
	mov	ecx,[rsp+8*(f+3)]
	rep	movsb
	mov	byte [rsp+8*(4+3)],1
    .close3:
	mov	rcx,r14
	call	[UnmapViewOfFile]
    .close2:
	mov	rcx,r13
	call	[CloseHandle]
    .close1:
	mov	rcx,r12
	call	[CloseHandle]
	mov	eax,[rsp+8*(4+3)]
	jmp	.fin
    .err:
	xor	eax,eax
    .fin:
	add	rsp,8*(4+4)
	pop	r14 r13 r12 rdi rsi
	retn

  DialogProc:
	push	r12 r13
a	=	2
b	=	4
c	=	sizeof.OPENFILENAME
d	=	(c+7)/8
e	=	(a+b+d+1) and 1
	sub	rsp,8*(b+d+e)
virtual at rsp+8*4
.ofn	OPENFILENAME
end virtual
	cmp	edx,WM_INITDIALOG
	je	.wm_initdialog
	cmp	edx,WM_COMMAND
	je	.wm_command
	cmp	edx,WM_CTLCOLORSTATIC
	je	.wm_ctlcolorstatic
	cmp	edx,WM_CLOSE
	je	.wm_close
	xor	eax,eax
	jmp	.fin
    .wm_initdialog:
	mov	r12,rcx
	cmp	[path],0
	jnz	.got_it
	call	install_dir
	test	eax,eax
	jnz	.getopenfilename
	lea	rdx,[_msnmsgr]
	lea	rcx,[path]
	call	[PathAppend]
      .got_it:
	xor	ecx,ecx
	call	[GetModuleHandle]
	lea	r8,[rsp+8*(4+0)]
	lea	rdx,[path]
	xchg	rax,rcx
	call	[ExtractAssociatedIcon]
	mov	r13,rax
	xor	ecx,ecx
	mov	[rsp+8*(4+0)],rcx
	mov	r9,rax
	mov	r8d,STM_SETICON
	lea	edx,[rcx+IDC_ICON_]
	mov	rcx,r12
	call	[SendDlgItemMessage]
	xchg	rax,r13
	call	[DestroyIcon]
	call	ptrn_check
	test	eax,eax
	je	.notmapped
	cmp	eax,1
	je	.notfound
	sub	eax,_size_of_patch
	mov	[address],eax
	mov	[rsp+8*(4+1)],r14
	mov	[rsp+8*(4+2)],rbx
	test	edx,edx
	je	.already
	mov	[text_color],0FF9490h
	lea	r8,[_unpatched]
	lea	rbx,[_patch]
	mov	r14l,1
	jmp	.set
      .already:
	mov	[text_color],00000FFh
	lea	r8,[_patched]
	lea	rbx,[_restore]
	mov	r14l,2
      .set:
	mov	edx,IDC_STATUS
	mov	rcx,r12
	call	[SetDlgItemText]
	mov	edx,IDC_PATCH
	mov	rcx,r12
	call	[GetDlgItem]
	mov	r13,rax
	mov	rdx,rbx
	xchg	rax,rcx
	call	[SetWindowText]
	movzx	r8,r14l
	mov	edx,GWL_USERDATA
	mov	rcx,r13
	call	[SetWindowLong]
	mov	r14,[rsp+8*(4+1)]
	mov	rbx,[rsp+8*(4+2)]
	jmp	.done
      .getopenfilename:
	mov	rdx,sizeof.OPENFILENAME
	lea	rcx,[.ofn]
	call	[RtlZeroMemory]
	lea	rdx,[_msnmsgr]
	lea	rcx,[path]
	call	[lstrcpy]
	mov	[.ofn.lStructSize],sizeof.OPENFILENAME
	mov	[.ofn.hwndOwner],r12
	lea	rax,[_filter]
	mov	[.ofn.lpstrFilter],rax
	lea	rax,[path]
	mov	[.ofn.lpstrFile],rax
	mov	[.ofn.nMaxFile],MAX_PATH
	lea	rax,[_title]
	mov	[.ofn.lpstrTitle],rax
	mov	[.ofn.Flags],OFN_FILEMUSTEXIST
	lea	rcx,[.ofn]
	call	[GetOpenFileName]
	test	eax,eax
	jnz	.got_it
	mov	rcx,r12
	jmp	.wm_close
      .notmapped:
	lea	r8,[_notmapped]
	jmp	.error
      .notfound:
	lea	r8,[_notfound]
      .error:
	mov	[text_color],0
	mov	edx,IDC_STATUS
	mov	rcx,r12
	call	[SetDlgItemText]
	mov	edx,IDC_PATCH
	mov	rcx,r12
	call	[GetDlgItem]
	mov	r13,rax
	lea	rdx,[_close]
	xchg	rax,rcx
	call	[SetWindowText]
	xor	r8,r8
	mov	edx,GWL_USERDATA
	mov	rcx,r13
	call	[SetWindowLong]
	jmp	.done
    .wm_command:
	cmp	r8,BN_CLICKED shl 16+IDC_PATCH
	jnz	.done
	mov	r12,rcx
	mov	edx,IDC_PATCH
	mov	rcx,r12
	call	[GetDlgItem]
	mov	edx,GWL_USERDATA
	xchg	rax,rcx
	call	[GetWindowLong]
	mov	rcx,r12
	test	eax,eax
	je	.wm_close
	lea	rdx,[_apply]
	cmp	eax,1
	je	.patch
	lea	rdx,[_remove]
      .patch:
	mov	r8d,_size_of_patch
	mov	ecx,[address]
	call	patch
	test	eax,eax
	je	.notmapped
	xor	r9,r9
	xor	r8,r8
	mov	edx,WM_INITDIALOG
	mov	rcx,r12
	call	[SendMessage]
	jmp	.done
    .wm_ctlcolorstatic:
	mov	r12,r8
	mov	edx,[text_color]
	mov	rcx,r8
	call	[SetTextColor]
	mov	edx,TRANSPARENT
	mov	rcx,r12
	call	[SetBkMode]
	mov	ecx,COLOR_MENU
	call	[GetSysColorBrush]
	jmp	.fin
    .wm_close:
	xor	edx,edx
	call	[EndDialog]
    .done:
	mov	eax,1
    .fin:
	add	rsp,8*(b+d+e)
	pop	r13 r12
	retn

  FindPattern:
	push	rsi rdi
	mov	rdi,rcx
	mov	rcx,rdx
	mov	r10,[rsp+8*(4+3)]
	dec	r10
    .loop:
	mov	al,[r8]
	repnz	scasb
	jnz	.not_found
	mov	r11,rcx
	mov	rdx,rdi
	lea	rsi,[r8+1]
	mov	rcx,r10
    .compare:
	repe	cmpsb
	jnz	.check_wildcard
	lea	rax,[rdx-1]
	jmp	.fin
    .check_wildcard:
	jecxz	.no_match
	mov	rax,rdi
	sub	rax,rdx
	cmp	byte [r9+rax],'?'
	je	.compare
    .no_match:
	mov	rdi,rdx
	mov	rcx,r11
	jmp	.loop
    .not_found:
	xor	eax,eax
    .fin:
	pop	rdi rsi
	retn

	include 'pe.inc'

section '.data' data readable writeable

  _msnmsgr db 'msnmsgr.exe',0
  _unpatched db 'Ready to patch..',0
  _patched db 'Already patched.',0
  _notfound db 'Pattern wasn''t found.',0
  _notmapped db 'Couldn''t map the file.',0
  _filter db 'Executables (*.exe)',0,'*.EXE',0,0
  _title db 'Couldn''t find Windows Live Messenger''s executable..',0
  _patch db 'PATCH',0
  _restore db 'RESTORE',0
  _close db 'CLOSE',0
  _key db 'Software\Microsoft\Windows Live\Messenger',0
  _value db 'InstallationDirectory',0

  _ptrn db 056h,0FFh,075h,008h,08Bh,0F1h,0E8h,000h,000h,000h,000h,084h,0C0h,074h,013h,0FFh,075h,008h,08Bh,0CEh,0E8h,000h,000h,000h,000h,084h,0C0h,074h,005h,033h,0C0h,040h,0EBh,002h,033h,0C0h,05Eh,05Dh,0C2h,004h,000h
  _mask db 'xxxxxxx????xxxxxxxxxx????xxxxxxxxxxxxxxxx'
  _size = $-_mask

  _apply  db 0B0h,001h,0C2h,004h,000h
  _remove db 08Bh,0FFh,055h,08Bh,0ECh
  _size_of_patch = $-_remove
  original_first_byte = 08Bh

  path rb MAX_PATH

  address rd 1
  text_color rd 1

section '.idata' import data readable

  IDD_MAIN   = 100
  IDC_PATCH  = 101
  IDC_STATUS = 102
  IDC_ICON_  = 103

  library kernel32,'KERNEL32.DLL',\
	  user32,'USER32.DLL',\
	  gdi32,'GDI32.DLL',\
	  advapi32,'ADVAPI32',\
	  shell32,'SHELL32.DLL',\
	  comdlg32,'COMDLG32.DLL',\
	  shlwapi,'SHLWAPI.DLL'

  include 'api\kernel32.inc'
  include 'api\user32.inc'
  include 'api\advapi32.inc'

  import gdi32,\
	 SetBkMode,'SetBkMode',\
	 SetTextColor,'SetTextColor'

  import shell32,\
	 ExtractAssociatedIcon,'ExtractAssociatedIconA'

  import comdlg32,\
	 GetOpenFileName,'GetOpenFileNameA'

  import shlwapi,\
	 PathAppend,'PathAppendA'

section '.rsrc' resource data readable

  directory RT_DIALOG,dialogs,\
	    RT_MANIFEST,manifests

  resource dialogs,\
	   IDD_MAIN,LANG_ENGLISH+SUBLANG_DEFAULT,main_dialog

  resource manifests,\
	   1,LANG_ENGLISH+SUBLANG_DEFAULT,manifest

  dialog main_dialog,'Patcher',0,0,148,74,WS_SYSMENU+WS_MINIMIZEBOX+DS_CENTER,,,'Terminal',10
    dialogitem 'button','',-1,6,3,130,34,WS_VISIBLE+BS_GROUPBOX
    dialogitem 'static','',IDC_ICON_,12,11,0,0,WS_VISIBLE+SS_ICON
    dialogitem 'static','',IDC_STATUS,35,18,100,10,WS_VISIBLE+SS_CENTER
    dialogitem 'button','',IDC_PATCH,6,40,130,12,WS_VISIBLE
  enddialog

  resdata manifest
    file 'manifest.xml'
  endres
