
IMAGE_DOS_SIGNATURE		 = 'MZ'
IMAGE_NT_SIGNATURE		 = 'PE'
IMAGE_NUMBEROF_DIRECTORY_ENTRIES = 16
IMAGE_DIRECTORY_ENTRY_IMPORT	 = 1
IMAGE_DIRECTORY_ENTRY_IAT	 = 12

struct IMAGE_DOS_HEADER
  e_magic    rw 1
  e_cblp     rw 1
  e_cp	     rw 1
  e_crlc     rw 1
  e_cparhdr  rw 1
  e_minalloc rw 1
  e_maxalloc rw 1
  e_ss	     rw 1
  e_sp	     rw 1
  e_csum     rw 1
  e_ip	     rw 1
  e_cs	     rw 1
  e_lfarlc   rw 1
  e_ovno     rw 1
  e_res      rw 4
  e_oemid    rw 1
  e_oeminfo  rw 1
  e_res2     rw 10
  e_lfanew   rd 1
ends

struct IMAGE_FILE_HEADER
  Machine	       rw 1
  NumberOfSections     rw 1
  TimeDateStamp        rd 1
  PointerToSymbolTable rd 1
  NumberOfSymbols      rd 1
  SizeOfOptionalHeader rw 1
  Characteristics      rw 1
ends

struct IMAGE_DATA_DIRECTORY
  VirtualAddress rd 1
  Size		 rd 1
ends

struct IMAGE_OPTIONAL_HEADER
  Magic 		      rw 1
  MajorLinkerVersion	      rb 1
  MinorLinkerVersion	      rb 1
  SizeOfCode		      rd 1
  SizeOfInitializedData       rd 1
  SizeOfUninitializedData     rd 1
  AddressOfEntryPoint	      rd 1
  BaseOfCode		      rd 1
  ImageBase		      rd 1
  SectionAlignment	      rd 1
  FileAlignment 	      rd 1
  MajorOperatingSystemVersion rw 1
  MinorOperatingSystemVersion rw 1
  MajorImageVersion	      rw 1
  MinorImageVersion	      rw 1
  MajorSubsystemVersion       rw 1
  MinorSubsystemVersion       rw 1
  Win32VersionValue	      rd 1
  SizeOfImage		      rd 1
  SizeOfHeaders 	      rd 1
  CheckSum		      rd 1
  Subsystem		      rw 1
  DllCharacteristics	      rw 1
  SizeOfStackReserve	      rd 1
  SizeOfStackCommit	      rd 1
  SizeOfHeapReserve	      rd 1
  SizeOfHeapCommit	      rd 1
  LoaderFlags		      rd 1
  NumberOfRvaAndSizes	      rd 1
  DataDirectory 	      IMAGE_DATA_DIRECTORY
			      rb (IMAGE_NUMBEROF_DIRECTORY_ENTRIES-1)*sizeof.IMAGE_DATA_DIRECTORY
ends

struct IMAGE_NT_HEADERS
  Signature	 rd 1
  FileHeader	 IMAGE_FILE_HEADER
  OptionalHeader IMAGE_OPTIONAL_HEADER
ends

struct IMAGE_OPTIONAL_HEADER64
  Magic 		      rw 1
  MajorLinkerVersion	      rb 1
  MinorLinkerVersion	      rb 1
  SizeOfCode		      rd 1
  SizeOfInitializedData       rd 1
  SizeOfUninitializedData     rd 1
  AddressOfEntryPoint	      rd 1
  BaseOfCode		      rd 1
  ImageBase		      rq 1
  SectionAlignment	      rd 1
  FileAlignment 	      rd 1
  MajorOperatingSystemVersion rw 1
  MinorOperatingSystemVersion rw 1
  MajorImageVersion	      rw 1
  MinorImageVersion	      rw 1
  MajorSubsystemVersion       rw 1
  MinorSubsystemVersion       rw 1
  Win32VersionValue	      rd 1
  SizeOfImage		      rd 1
  SizeOfHeaders 	      rd 1
  CheckSum		      rd 1
  Subsystem		      rw 1
  DllCharacteristics	      rw 1
  SizeOfStackReserve	      rq 1
  SizeOfStackCommit	      rq 1
  SizeOfHeapReserve	      rq 1
  SizeOfHeapCommit	      rq 1
  LoaderFlags		      rd 1
  NumberOfRvaAndSizes	      rd 1
  DataDirectory 	      IMAGE_DATA_DIRECTORY
			      rb (IMAGE_NUMBEROF_DIRECTORY_ENTRIES-1)*sizeof.IMAGE_DATA_DIRECTORY
ends

struct IMAGE_NT_HEADERS64
  Signature	 rd 1
  FileHeader	 IMAGE_FILE_HEADER
  OptionalHeader IMAGE_OPTIONAL_HEADER64
ends

IMAGE_SIZEOF_SHORT_NAME     = 8
IMAGE_SIZEOF_SECTION_HEADER = 40

struct IMAGE_SECTION_HEADER
  Name			 rb IMAGE_SIZEOF_SHORT_NAME
  union
    Misc.PhysicalAddress rd 1
    Misc.VirtualSize	 rd 1
  ends
  VirtualAddress	 rd 1
  SizeOfRawData 	 rd 1
  PointerToRawData	 rd 1
  PointerToRelocations	 rd 1
  PointerToLinenumbers	 rd 1
  NumberOfRelocations	 rw 1
  NumberOfLinenumbers	 rw 1
  Characteristics	 rd 1
ends
